/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMAssignedShiftsTableModel;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMRoleNameEditor;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMShiftSelectionDialog;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWSIMAssignedShiftsPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWSIMPropertyChangeListener {
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_assignedShiftsTable = null;
    private VWSIMAssignedShiftsTableModel m_assignedShiftsTableModel = null;
    private VWSIMShiftSelectionDialog m_shiftSelectionDialog = null;
    private VWScenarioResourceDefinition m_resourceDefinition = null;
    private VWSIMPropertyData m_propertyData = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.createControls();
        this.setEnabled(false);
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public void setResourceDefinition(VWScenarioResourceDefinition resourceDef) {
        this.m_resourceDefinition = resourceDef;
        if (this.m_assignedShiftsTable != null && this.m_assignedShiftsTableModel != null) {
            this.m_assignedShiftsTable.stopEditing();
            this.m_assignedShiftsTableModel.reinitialize(resourceDef);
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            this.m_assignedShiftsTable.clearSelection();
            if (this.m_assignedShiftsTableModel.getRowCount() > 0) {
                this.m_assignedShiftsTable.setRowSelectionInterval(0, 0);
            }
        }
        this.setEnabled(resourceDef != null);
    }

    public void setEnabled(boolean bEnable) {
        if (this.m_toolBarBorder != null) {
            if (bEnable) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 32));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            }
        }
        if (this.m_assignedShiftsTable != null) {
            this.m_assignedShiftsTable.setEnabled(bEnable);
        }
        super.setEnabled(bEnable);
    }

    public void releaseReferences() {
        this.m_toolBarBorder = null;
        this.m_assignedShiftsTable = null;
        this.m_assignedShiftsTableModel = null;
        this.m_shiftSelectionDialog = null;
        this.m_propertyData = null;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_assignedShiftsTable.getSelectedRow()) {
                    this.m_assignedShiftsTable.clearSelection();
                }
                if (nRow >= 0 && this.m_assignedShiftsTableModel.getRowCount() > 0) {
                    this.m_assignedShiftsTable.setRowSelectionInterval(nRow, nRow);
                    break;
                }
                this.updateControlStates();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.updateControlStates();
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 32: {
                    this.selectShifts();
                    break;
                }
                case 0x10000000: {
                    int nRowIndex = this.m_assignedShiftsTable.getSelectedRow();
                    if (nRowIndex == -1) {
                        return;
                    }
                    this.m_assignedShiftsTableModel.deleteItem(nRowIndex);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        if (event.getSource() == this.m_assignedShiftsTableModel) {
            return;
        }
        switch (event.getID()) {
            case 103: {
                if (this.m_assignedShiftsTable == null) break;
                this.m_assignedShiftsTable.stopEditing();
                break;
            }
            case 116: 
            case 117: 
            case 121: {
                if (this.m_resourceDefinition == null) break;
                this.handleUpdateResource(this.m_resourceDefinition.getName());
                break;
            }
            case 108: {
                if (this.m_resourceDefinition == null || event.getParam() == null) break;
                String[] names = (String[])event.getParam();
                this.handleUpdateResource(names[1]);
                break;
            }
            case 109: {
                if (this.m_resourceDefinition == null || event.getParam() == null) break;
                String name = (String)event.getParam();
                this.handleUpdateResource(name);
            }
        }
    }

    private void createControls() {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout());
            this.m_toolBarBorder = new VWToolbarBorder(VWSIMResource.s_assignedShifts, 0x10000020);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.add((Component)this.m_toolBarBorder, "Center");
            this.createTable();
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_assignedShiftsTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createTable() {
        TableColumn tcElement = null;
        this.m_assignedShiftsTableModel = new VWSIMAssignedShiftsTableModel(this.m_propertyData);
        this.m_assignedShiftsTableModel.addTableModelListener(this);
        this.m_assignedShiftsTable = new VWTable(this.m_assignedShiftsTableModel);
        this.m_assignedShiftsTable.setRowSelectionAllowed(true);
        this.m_assignedShiftsTable.getSelectionModel().addListSelectionListener(this);
        this.m_assignedShiftsTable.getSelectionModel().setSelectionMode(0);
        this.m_assignedShiftsTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_assignedShiftsTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 4));
        tcElement = this.m_assignedShiftsTable.getColumnModel().getColumn(1);
        if (tcElement != null) {
            tcElement.setCellEditor(new VWSIMRoleNameEditor(this.m_assignedShiftsTableModel));
        }
    }

    private void selectShifts() {
        try {
            if (this.m_assignedShiftsTableModel != null) {
                if (this.m_shiftSelectionDialog == null) {
                    this.m_shiftSelectionDialog = new VWSIMShiftSelectionDialog(this.m_propertyData);
                }
                String[] selectedShiftNames = this.m_assignedShiftsTableModel.getSelectedShiftNames();
                this.m_shiftSelectionDialog.initialize(selectedShiftNames);
                this.m_shiftSelectionDialog.show();
                if (this.m_shiftSelectionDialog.getExitStatus() == 0) {
                    selectedShiftNames = this.m_shiftSelectionDialog.getSelectedShiftNames();
                    this.m_assignedShiftsTableModel.updateAssignedShifts(selectedShiftNames);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void handleUpdateResource(String resourceName) {
        if (resourceName != null && resourceName.length() > 0 && VWStringUtils.compare(resourceName, this.m_resourceDefinition.getName()) == 0) {
            int nSelectedRow = this.m_assignedShiftsTable.getSelectedRow();
            this.setResourceDefinition(this.m_resourceDefinition);
            if (nSelectedRow != -1 && this.m_assignedShiftsTableModel.getRowCount() > nSelectedRow) {
                this.m_assignedShiftsTable.setRowSelectionInterval(nSelectedRow, nSelectedRow);
            }
        }
    }

    private void updateControlStates() {
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
        int nRowIndex = this.m_assignedShiftsTable.getSelectedRow();
        if (nRowIndex != -1) {
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, Integer.MAX_VALUE));
        }
    }
}

